#include "ksiegozbior.h"
#include "ksiazka.h"
#include <iostream>

using namespace std;

Ksiegozbior::~Ksiegozbior(){
	for ( list<Ksiazka*>::iterator it = listaKsiazek_.begin();
		it != listaKsiazek_.end(); ++it ){
		delete *it;
	}
}

void Ksiegozbior::dodaj_ksiazke(Ksiazka* ksiazka){
	listaKsiazek_.push_back( ksiazka );
}

bool Ksiegozbior::wypozycz_ksiazke(const string& syg){
	for ( list<Ksiazka*>::iterator it = listaKsiazek_.begin();
		it != listaKsiazek_.end(); ++it ){
			if ( (*it)->sygnatura() == syg ){
				(*it)->wypozycz();
				return true;
			}
	}
	return false;
}

bool Ksiegozbior::oddaj_ksiazke(const string& syg){
	for ( list<Ksiazka*>::iterator it = listaKsiazek_.begin();
		it != listaKsiazek_.end(); ++it ){
		if ( (*it)->sygnatura() == syg ){
				(*it)->wypozycz();
				return true;
		}
	}
	return false;
}

void Ksiegozbior::wyswietl(){
	cout << endl << "--------------------------------" << endl << endl;
	for ( list<Ksiazka*>::iterator it = listaKsiazek_.begin();
		it != listaKsiazek_.end(); ++it ){
		cout << **it << endl;
	}
	cout << endl << "--------------------------------" << endl << endl;
}